/**
 * One-off script: delete all scan history, favorites, and shopping list rows.
 * Run from server dir: npx tsx scripts/clear-scan-history.ts
 */
import dotenv from 'dotenv';
import path from 'path';
import { query } from '../src/db';

dotenv.config({ path: path.resolve(__dirname, '../.env') });

async function main() {
  const scanResult = await query('DELETE FROM scan_history');
  console.log('Deleted scan history rows:', scanResult.rowCount ?? 0);

  const favResult = await query('DELETE FROM user_favorites');
  console.log('Deleted user_favorites rows:', favResult.rowCount ?? 0);

  const shopResult = await query('DELETE FROM shopping_list');
  console.log('Deleted shopping_list rows:', shopResult.rowCount ?? 0);
}

main()
  .then(() => process.exit(0))
  .catch((err) => {
    console.error(err);
    process.exit(1);
  });
