import { Router, Response } from 'express';
import { query } from '../db';
import { authenticate, AuthRequest } from '../middleware/auth';
import { v4 as uuidv4 } from 'uuid';

const router = Router();

// Get notifications for current user
router.get('/', authenticate, async (req: AuthRequest, res: Response) => {
  try {
    const result = await query(
      'SELECT * FROM notifications WHERE user_id = $1 ORDER BY created_at DESC',
      [req.user!.id]
    );
    res.json(result.rows);
  } catch (error) {
    throw error;
  }
});

// Mark as read
router.patch('/:id/read', authenticate, async (req: AuthRequest, res: Response) => {
  try {
    await query(
      'UPDATE notifications SET is_read = true WHERE id = $1 AND user_id = $2',
      [req.params.id, req.user!.id]
    );
    res.json({ ok: true });
  } catch (error) {
    throw error;
  }
});

// Mark all as read
router.post('/mark-all-read', authenticate, async (req: AuthRequest, res: Response) => {
  try {
    await query(
      'UPDATE notifications SET is_read = true WHERE user_id = $1',
      [req.user!.id]
    );
    res.json({ ok: true });
  } catch (error) {
    throw error;
  }
});

// Delete notification
router.delete('/:id', authenticate, async (req: AuthRequest, res: Response) => {
  try {
    await query(
      'DELETE FROM notifications WHERE id = $1 AND user_id = $2',
      [req.params.id, req.user!.id]
    );
    res.status(204).send();
  } catch (error) {
    throw error;
  }
});

// Clear all
router.delete('/', authenticate, async (req: AuthRequest, res: Response) => {
  try {
    await query('DELETE FROM notifications WHERE user_id = $1', [req.user!.id]);
    res.status(204).send();
  } catch (error) {
    throw error;
  }
});

export default router;
