import { Toaster } from "@/components/ui/toaster";
import { Toaster as Sonner } from "@/components/ui/sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import { BrowserRouter, Routes, Route } from "react-router-dom";
import { AuthProvider } from "@/contexts/AuthContext";
import { FavoritesProvider } from "@/contexts/FavoritesContext";
import { ShoppingListProvider } from "@/contexts/ShoppingListContext";
import Index from "./pages/Index";
import Cosmetics from "./pages/Cosmetics";
import ChemicalHazards from "./pages/ChemicalHazards";
import IngredientScanner from "./pages/IngredientScanner";
import FoodComparison from "./pages/FoodComparison";
import TobinComparison from "./pages/TobinComparison";
import TobinExposureTracker from "./pages/TobinExposureTracker";
import Achievements from "./pages/Achievements";
import Community from "./pages/Community";
import UserProfile from "./pages/UserProfile";
import Auth from "./pages/Auth";
import Profile from "./pages/Profile";
import ShoppingList from "./pages/ShoppingList";
import BarcodeScanner from "./pages/BarcodeScanner";
import Recipes from "./pages/Recipes";
import SharedRecipe from "./pages/SharedRecipe";
import PhytoestrogenScanner from "./pages/PhytoestrogenScanner";
import Subscription from "./pages/Subscription";
import SubscriptionSuccess from "./pages/SubscriptionSuccess";
import SubscriptionCanceled from "./pages/SubscriptionCanceled";
import NotFound from "./pages/NotFound";
import { BottomNavigation } from "./components/BottomNavigation";
import { useMealReminders } from "./hooks/useMealReminders";

const queryClient = new QueryClient();

function AppContent() {
  // Check for meal prep reminders when user logs in
  useMealReminders();

  return (
    <>
      <div className="pb-14 md:pb-0">
        <Routes>
          <Route path="/" element={<Index />} />
          <Route path="/cosmetics" element={<Cosmetics />} />
          <Route path="/chemical-hazards" element={<ChemicalHazards />} />
          <Route path="/ingredient-scanner" element={<IngredientScanner />} />
          <Route path="/food-comparison" element={<FoodComparison />} />
          <Route path="/tobin-comparison" element={<TobinComparison />} />
          <Route path="/tobin-tracker" element={<TobinExposureTracker />} />
          <Route path="/achievements" element={<Achievements />} />
          <Route path="/community" element={<Community />} />
          <Route path="/user/:userId" element={<UserProfile />} />
          <Route path="/auth" element={<Auth />} />
          <Route path="/profile" element={<Profile />} />
          <Route path="/shopping-list" element={<ShoppingList />} />
          <Route path="/barcode-scanner" element={<BarcodeScanner />} />
          <Route path="/recipes" element={<Recipes />} />
          <Route path="/shared-recipe/:token" element={<SharedRecipe />} />
          <Route path="/phytoestrogen-scanner" element={<PhytoestrogenScanner />} />
          <Route path="/subscription" element={<Subscription />} />
          <Route path="/subscription-success" element={<SubscriptionSuccess />} />
          <Route path="/subscription-canceled" element={<SubscriptionCanceled />} />
          {/* ADD ALL CUSTOM ROUTES ABOVE THE CATCH-ALL "*" ROUTE */}
          <Route path="*" element={<NotFound />} />
        </Routes>
      </div>
      <BottomNavigation />
    </>
  );
}

const App = () => (
  <QueryClientProvider client={queryClient}>
    <TooltipProvider>
      <Toaster />
      <Sonner />
      <BrowserRouter>
        <AuthProvider>
          <FavoritesProvider>
            <ShoppingListProvider>
              <AppContent />
            </ShoppingListProvider>
          </FavoritesProvider>
        </AuthProvider>
      </BrowserRouter>
    </TooltipProvider>
  </QueryClientProvider>
);

export default App;