import { Component, ReactNode } from "react";

interface Props {
  children: ReactNode;
}

interface State {
  hasError: boolean;
  error: Error | null;
}

export class ErrorBoundary extends Component<Props, State> {
  state: State = { hasError: false, error: null };

  static getDerivedStateFromError(error: Error): State {
    return { hasError: true, error };
  }

  componentDidCatch(error: Error, errorInfo: React.ErrorInfo) {
    console.error("App error:", error, errorInfo);
  }

  render() {
    if (this.state.hasError && this.state.error) {
      return (
        <div style={{
          padding: "2rem",
          fontFamily: "system-ui, sans-serif",
          maxWidth: "600px",
          margin: "2rem auto",
        }}>
          <h1 style={{ color: "#b91c1c", marginBottom: "1rem" }}>Something went wrong</h1>
          <pre style={{
            background: "#fef2f2",
            padding: "1rem",
            borderRadius: "8px",
            overflow: "auto",
            fontSize: "14px",
          }}>
            {this.state.error.message}
          </pre>
          <p style={{ marginTop: "1rem", color: "#666" }}>
            Check the browser console for more details.
          </p>
          <button
            onClick={() => window.location.reload()}
            style={{
              marginTop: "1rem",
              padding: "0.5rem 1rem",
              cursor: "pointer",
            }}
          >
            Reload page
          </button>
        </div>
      );
    }
    return this.props.children;
  }
}
