import { Link, useLocation } from "react-router-dom";
import { Home, Sparkles, ChefHat, ScanBarcode, User } from "lucide-react";
import { cn } from "@/lib/utils";
import { useAuth } from "@/hooks/useAuth";

const navItems = [
  { icon: Home, label: "Home", path: "/" },
  { icon: Sparkles, label: "Cosmetics", path: "/cosmetics" },
  { icon: ChefHat, label: "Recipes", path: "/recipes" },
  { icon: ScanBarcode, label: "Scan", path: "/barcode-scanner" },
  { icon: User, label: "Profile", path: "/profile", authRequired: true },
];

export function BottomNavigation() {
  const location = useLocation();
  const { user } = useAuth();

  return (
    <nav className="fixed bottom-0 left-0 right-0 z-50 bg-background/95 backdrop-blur-md border-t border-border md:hidden safe-area-pb">
      <div className="flex items-center justify-around h-14 px-2">
        {navItems.map((item) => {
          // If auth required and no user, redirect to auth page
          const targetPath = item.authRequired && !user ? "/auth" : item.path;
          const isActive = location.pathname === item.path || 
            (item.authRequired && !user && location.pathname === "/auth");

          return (
            <Link
              key={item.path}
              to={targetPath}
              className={cn(
                "flex flex-col items-center justify-center gap-0.5 px-3 py-1.5 rounded-lg transition-colors min-w-[56px]",
                isActive
                  ? "text-primary bg-primary/10"
                  : "text-muted-foreground hover:text-foreground hover:bg-muted/50"
              )}
            >
              <item.icon className={cn(
                "h-5 w-5 transition-transform",
                isActive && "scale-110"
              )} />
              <span className="text-[10px] font-medium leading-tight">{item.label}</span>
            </Link>
          );
        })}
      </div>
    </nav>
  );
}
