import { Button } from "@/components/ui/button";
import { AlertTriangle, CheckCircle, Sparkles, LayoutGrid } from "lucide-react";

interface CategoryFilterProps {
  selectedCategory: number | null;
  onChange: (category: number | null) => void;
}

const categories = [
  { id: null, label: "All Foods", icon: LayoutGrid, color: "text-foreground" },
  { id: 1, label: "Avoid", icon: AlertTriangle, color: "text-category-danger" },
  { id: 2, label: "Conditional", icon: AlertTriangle, color: "text-category-warning" },
  { id: 3, label: "Safe", icon: CheckCircle, color: "text-category-safe" },
  { id: 4, label: "Therapeutic", icon: Sparkles, color: "text-category-therapeutic" },
];

export function CategoryFilter({ selectedCategory, onChange }: CategoryFilterProps) {
  return (
    <div className="flex flex-wrap gap-1.5 sm:gap-2 justify-center px-1">
      {categories.map((cat) => {
        const Icon = cat.icon;
        const isSelected = selectedCategory === cat.id;
        
        return (
          <Button
            key={cat.id ?? "all"}
            variant={isSelected ? "default" : "outline"}
            size="sm"
            onClick={() => onChange(cat.id)}
            className={`
              transition-all duration-300 text-xs sm:text-sm h-7 sm:h-8 px-2 sm:px-3
              ${isSelected 
                ? cat.id === 1 ? 'gradient-danger border-0 text-white' :
                  cat.id === 2 ? 'bg-category-warning border-0 text-white' :
                  cat.id === 3 ? 'gradient-safe border-0 text-white' :
                  cat.id === 4 ? 'gradient-therapeutic border-0 text-white' :
                  'gradient-hero border-0'
                : ''
              }
            `}
          >
            <Icon className={`h-3.5 w-3.5 sm:h-4 sm:w-4 mr-1 sm:mr-1.5 ${!isSelected ? cat.color : ''}`} />
            {cat.label}
          </Button>
        );
      })}
    </div>
  );
}
