import { Input } from "@/components/ui/input";
import { Search, ScanBarcode, X } from "lucide-react";
import { Button } from "@/components/ui/button";
import { useNavigate } from "react-router-dom";

interface CosmeticsSearchBarProps {
  value: string;
  onChange: (value: string) => void;
}

export function CosmeticsSearchBar({ value, onChange }: CosmeticsSearchBarProps) {
  const navigate = useNavigate();

  const handleScan = () => {
    navigate("/barcode-scanner");
  };

  return (
    <div className="relative w-full max-w-2xl mx-auto px-1">
      <div className="relative">
        <Search className="absolute left-3 sm:left-4 top-1/2 -translate-y-1/2 h-4 w-4 sm:h-5 sm:w-5 text-muted-foreground" />
        <Input
          type="text"
          placeholder="Search cosmetics or chemicals..."
          value={value}
          onChange={(e) => onChange(e.target.value)}
          className="pl-9 sm:pl-12 pr-20 sm:pr-28 h-11 sm:h-14 text-sm sm:text-lg rounded-xl sm:rounded-2xl border-2 border-border/50 focus:border-primary bg-card shadow-soft transition-all duration-300 focus:shadow-card"
        />
        {value && (
          <button
            onClick={() => onChange("")}
            className="absolute right-16 sm:right-24 top-1/2 -translate-y-1/2 p-1 hover:bg-muted rounded-full transition-colors"
          >
            <X className="h-3.5 w-3.5 sm:h-4 sm:w-4 text-muted-foreground" />
          </button>
        )}
        <Button
          onClick={handleScan}
          variant="default"
          size="sm"
          className="absolute right-1.5 sm:right-2 top-1/2 -translate-y-1/2 rounded-lg sm:rounded-xl gradient-hero border-0 gap-1 sm:gap-1.5 px-2 sm:px-3 h-8 sm:h-9"
        >
          <ScanBarcode className="h-3.5 w-3.5 sm:h-4 sm:w-4" />
          <span className="text-xs sm:text-sm">Scan</span>
        </Button>
      </div>
    </div>
  );
}
