import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Zap, Flame, Info } from "lucide-react";

export function EquationDisplay() {
  return (
    <Card className="shadow-card">
      <CardHeader className="pb-2 sm:pb-3 p-3 sm:p-4 md:p-6">
        <CardTitle className="flex items-center gap-1.5 sm:gap-2 text-base sm:text-lg font-display">
          <Info className="h-4 w-4 sm:h-5 sm:w-5 text-primary" />
          Understanding the Indices
        </CardTitle>
      </CardHeader>
      <CardContent className="p-3 sm:p-4 md:p-6 pt-0">
        <Tabs defaultValue="gi" className="w-full">
          <TabsList className="grid w-full grid-cols-2 mb-3 sm:mb-4 h-9 sm:h-10">
            <TabsTrigger value="gi" className="flex items-center gap-1 sm:gap-2 text-xs sm:text-sm">
              <Zap className="h-3.5 w-3.5 sm:h-4 sm:w-4" />
              GI* Equation
            </TabsTrigger>
            <TabsTrigger value="li" className="flex items-center gap-1 sm:gap-2 text-xs sm:text-sm">
              <Flame className="h-3.5 w-3.5 sm:h-4 sm:w-4" />
              LI Equation
            </TabsTrigger>
          </TabsList>
          
          <TabsContent value="gi" className="space-y-3 sm:space-y-4">
            <div className="p-2.5 sm:p-3 md:p-4 bg-secondary/50 rounded-lg font-mono text-center text-xs sm:text-sm overflow-x-auto">
              <p className="text-sm sm:text-base md:text-lg whitespace-nowrap">GI* = (C<sub>net</sub> × k<sub>abs</sub> × I<sub>sec</sub>) / (F<sub>fiber</sub> + P<sub>buffer</sub>)</p>
            </div>
            <div className="space-y-1.5 sm:space-y-2 text-xs sm:text-sm text-muted-foreground">
              <p><strong>C<sub>net</sub></strong> = Net digestible carbohydrates (g)</p>
              <p><strong>k<sub>abs</sub></strong> = Carbohydrate absorption coefficient (0-1)</p>
              <p><strong>I<sub>sec</sub></strong> = Insulin secretion factor</p>
              <p><strong>F<sub>fiber</sub></strong> = Grams of fiber</p>
              <p><strong>P<sub>buffer</sub></strong> = Protein buffering factor (g × 0.5)</p>
            </div>
            <div className="p-2.5 sm:p-3 bg-primary/5 rounded-lg border border-primary/20">
              <p className="text-xs sm:text-sm">
                <strong>High GI*</strong> → Rapid glycogen filling + insulin spike<br/>
                <strong>Low GI*</strong> → Minimal insulin, stable glucose
              </p>
            </div>
          </TabsContent>
          
          <TabsContent value="li" className="space-y-3 sm:space-y-4">
            <div className="p-2.5 sm:p-3 md:p-4 bg-secondary/50 rounded-lg font-mono text-center text-xs sm:text-sm overflow-x-auto">
              <p className="text-sm sm:text-base md:text-lg whitespace-nowrap">LI = ((I<sub>sec</sub> × C<sub>net</sub>) + (F<sub>comb</sub> × k<sub>DNL</sub>)) / (AMPK<sub>score</sub> + M<sub>eff</sub>)</p>
            </div>
            <div className="space-y-1.5 sm:space-y-2 text-xs sm:text-sm text-muted-foreground">
              <p><strong>I<sub>sec</sub></strong> = Insulinogenic response</p>
              <p><strong>F<sub>comb</sub></strong> = Fat-carbohydrate co-ingestion factor</p>
              <p><strong>k<sub>DNL</sub></strong> = Hepatic de novo lipogenesis constant</p>
              <p><strong>AMPK<sub>score</sub></strong> = AMPK activation potential</p>
              <p><strong>M<sub>eff</sub></strong> = Mitochondrial efficiency score</p>
            </div>
            <div className="p-2.5 sm:p-3 bg-destructive/5 rounded-lg border border-destructive/20">
              <p className="text-xs sm:text-sm">
                <strong>LI &gt; 1.0</strong> → Net fat storage<br/>
                <strong>LI &lt; 0.5</strong> → Fat-neutral or fat-loss<br/>
                <strong>LI &lt; 0.3</strong> → Therapeutic (reverses insulin resistance)
              </p>
            </div>
          </TabsContent>
        </Tabs>
      </CardContent>
    </Card>
  );
}
