import { Heart } from 'lucide-react';
import { Button } from '@/components/ui/button';
import { useFavorites } from '@/contexts/FavoritesContext';
import { cn } from '@/lib/utils';

interface FavoriteButtonProps {
  itemId: string;
  itemType: 'food' | 'cosmetic';
  className?: string;
  size?: 'sm' | 'default';
}

export const FavoriteButton = ({ itemId, itemType, className, size = 'default' }: FavoriteButtonProps) => {
  const { isFavorite, toggleFavorite } = useFavorites();
  const isFav = isFavorite(itemId, itemType);

  const handleClick = (e: React.MouseEvent) => {
    e.stopPropagation();
    toggleFavorite(itemId, itemType);
  };

  return (
    <Button
      variant="ghost"
      size={size === 'sm' ? 'icon' : 'default'}
      className={cn(
        'transition-colors',
        size === 'sm' ? 'h-8 w-8' : 'h-9 w-9',
        className
      )}
      onClick={handleClick}
    >
      <Heart 
        className={cn(
          'transition-colors',
          size === 'sm' ? 'h-4 w-4' : 'h-5 w-5',
          isFav ? 'fill-red-500 text-red-500' : 'text-muted-foreground hover:text-red-500'
        )}
      />
    </Button>
  );
};
