import { Button } from '@/components/ui/button';
import { UserPlus, UserMinus, Loader2 } from 'lucide-react';
import { useFollows } from '@/hooks/useFollows';
import { useAuth } from '@/hooks/useAuth';

interface FollowButtonProps {
  userId: string;
  variant?: 'default' | 'outline' | 'ghost';
  size?: 'default' | 'sm' | 'lg' | 'icon';
  showText?: boolean;
}

export const FollowButton = ({ 
  userId, 
  variant = 'default',
  size = 'default',
  showText = true 
}: FollowButtonProps) => {
  const { user } = useAuth();
  const { isUserFollowed, toggleFollow, loading } = useFollows();

  // Don't show button for own profile or if not logged in
  if (!user || user.id === userId) {
    return null;
  }

  const following = isUserFollowed(userId);

  return (
    <Button
      variant={following ? 'outline' : variant}
      size={size}
      onClick={() => toggleFollow(userId)}
      disabled={loading}
      className="gap-2"
    >
      {loading ? (
        <Loader2 className="h-4 w-4 animate-spin" />
      ) : following ? (
        <>
          <UserMinus className="h-4 w-4" />
          {showText && 'Following'}
        </>
      ) : (
        <>
          <UserPlus className="h-4 w-4" />
          {showText && 'Follow'}
        </>
      )}
    </Button>
  );
};
