import { Zap, Flame, Shield, TrendingDown, Sparkles, Scale } from "lucide-react";
import { Link } from "react-router-dom";
import { Button } from "@/components/ui/button";
import { UserMenu } from "@/components/UserMenu";

export function HeroSection() {
  return (
    <section className="relative py-8 sm:py-12 md:py-16 px-3 sm:px-4 overflow-hidden">
      {/* Background gradient */}
      <div className="absolute inset-0 gradient-hero opacity-5" />
      <div className="absolute top-0 right-0 w-48 sm:w-64 md:w-96 h-48 sm:h-64 md:h-96 bg-primary/10 rounded-full blur-3xl -translate-y-1/2 translate-x-1/2" />
      <div className="absolute bottom-0 left-0 w-32 sm:w-48 md:w-64 h-32 sm:h-48 md:h-64 bg-accent/10 rounded-full blur-3xl translate-y-1/2 -translate-x-1/2" />
      
      {/* User Menu */}
      <div className="absolute top-4 right-4 z-10">
        <UserMenu />
      </div>
      
      <div className="relative max-w-4xl mx-auto text-center space-y-4 sm:space-y-6">
        <div className="inline-flex items-center gap-1.5 sm:gap-2 px-3 sm:px-4 py-1.5 sm:py-2 bg-primary/10 rounded-full text-primary text-xs sm:text-sm font-medium animate-fade-in-up">
          <Shield className="h-3 w-3 sm:h-4 sm:w-4" />
          Science-Based Food Analysis
        </div>
        
        <h1 className="text-2xl sm:text-3xl md:text-4xl lg:text-5xl xl:text-6xl font-display font-bold tracking-tight animate-fade-in-up animate-delay-100 px-2">
          <span className="text-gradient-hero">Metabolic Food Scanner</span>
        </h1>
        
        <p className="text-sm sm:text-base md:text-lg lg:text-xl text-muted-foreground max-w-2xl mx-auto animate-fade-in-up animate-delay-200 px-2">
          Analyze foods using the <strong>Lipogenic Index (LI)</strong> and <strong>Glycogenic Index (GI*)</strong> to understand their true impact on weight gain and metabolic health.
        </p>
        
        <div className="flex flex-wrap justify-center gap-3 sm:gap-4 md:gap-6 pt-2 sm:pt-4 animate-fade-in-up animate-delay-300 px-2">
          <div className="flex items-center gap-1.5 sm:gap-2 text-xs sm:text-sm">
            <div className="p-1.5 sm:p-2 rounded-lg bg-category-danger/10">
              <Flame className="h-4 w-4 sm:h-5 sm:w-5 text-category-danger" />
            </div>
            <span>Track Lipogenic Impact</span>
          </div>
          <div className="flex items-center gap-1.5 sm:gap-2 text-xs sm:text-sm">
            <div className="p-1.5 sm:p-2 rounded-lg bg-category-warning/10">
              <Zap className="h-4 w-4 sm:h-5 sm:w-5 text-category-warning" />
            </div>
            <span>Measure Insulin Response</span>
          </div>
          <div className="flex items-center gap-1.5 sm:gap-2 text-xs sm:text-sm">
            <div className="p-1.5 sm:p-2 rounded-lg bg-category-safe/10">
              <TrendingDown className="h-4 w-4 sm:h-5 sm:w-5 text-category-safe" />
            </div>
            <span>Find Healthy Alternatives</span>
          </div>
        </div>
        
        {/* Core Principle */}
        <div className="mt-4 sm:mt-6 md:mt-8 p-4 sm:p-5 md:p-6 bg-card rounded-xl sm:rounded-2xl shadow-card border max-w-2xl mx-auto animate-fade-in-up animate-delay-300">
          <p className="text-base sm:text-lg font-display font-semibold text-foreground mb-1.5 sm:mb-2">
            The Master Principle
          </p>
          <p className="text-sm sm:text-base text-muted-foreground">
            Weight gain is not caused by calories. It is caused by foods with <strong className="text-category-danger">high lipogenic and glycogenic indices</strong> acting on a toxin-injured metabolic system.
          </p>
        </div>
        
        {/* Navigation Buttons */}
        <div className="mt-4 sm:mt-6 flex flex-col sm:flex-row flex-wrap justify-center gap-2 sm:gap-3 animate-fade-in-up animate-delay-300 px-2">
          <Link to="/food-comparison" className="w-full sm:w-auto">
            <Button variant="default" size="default" className="gap-2 w-full sm:w-auto sm:px-6">
              <Scale className="h-4 w-4" />
              Compare Foods
            </Button>
          </Link>
          <Link to="/cosmetics" className="w-full sm:w-auto">
            <Button variant="outline" size="default" className="gap-2 w-full sm:w-auto sm:px-6">
              <Sparkles className="h-4 w-4" />
              <span className="hidden xs:inline">Explore</span> Cosmetics & Hazards
            </Button>
          </Link>
        </div>
      </div>
    </section>
  );
}
