import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Utensils, CheckCircle, XCircle, ArrowRight } from "lucide-react";

export function MealGuide() {
  const goodMeals = [
    { name: "Eggs + Greens + Olive Oil", emoji: "🥚🥬🫒" },
    { name: "Salmon + Cruciferous Vegetables", emoji: "🐟🥦" },
    { name: "Grass-fed Beef + Salad + Avocado", emoji: "🥩🥗🥑" },
    { name: "Chicken + Spinach + EVOO", emoji: "🍗🥬🫒" },
  ];
  
  const avoidMeals = [
    { name: "Bread + Butter (Carb + Fat combo)", emoji: "🍞🧈" },
    { name: "Pasta with Cream Sauce", emoji: "🍝" },
    { name: "Burger with Fries", emoji: "🍔🍟" },
    { name: "Cereal with Milk", emoji: "🥣🥛" },
  ];
  
  return (
    <Card className="shadow-card">
      <CardHeader className="pb-2 sm:pb-3 p-3 sm:p-4 md:p-6">
        <CardTitle className="flex items-center gap-1.5 sm:gap-2 text-base sm:text-lg font-display">
          <Utensils className="h-4 w-4 sm:h-5 sm:w-5 text-primary" />
          Meal Construction Guide
        </CardTitle>
      </CardHeader>
      <CardContent className="space-y-4 sm:space-y-6 p-3 sm:p-4 md:p-6 pt-0">
        {/* Decision Rule */}
        <div className="p-3 sm:p-4 gradient-hero rounded-lg sm:rounded-xl text-primary-foreground">
          <p className="font-display font-semibold text-center mb-1.5 sm:mb-2 text-sm sm:text-base">The Golden Rule</p>
          <p className="text-center text-xs sm:text-sm opacity-90">
            Choose foods where <strong>LI &lt; 0.5</strong> AND <strong>GI* &lt; 0.6</strong>
          </p>
          <div className="flex flex-wrap justify-center items-center gap-1.5 sm:gap-2 mt-2 sm:mt-3 text-sm sm:text-base md:text-lg font-mono">
            <span>Protein</span>
            <span className="text-base sm:text-lg md:text-xl">+</span>
            <span>Fiber</span>
            <span className="text-base sm:text-lg md:text-xl">+</span>
            <span>Healthy Fat</span>
          </div>
          <p className="text-center text-[10px] sm:text-xs mt-1.5 sm:mt-2 opacity-75">(No naked carbohydrates)</p>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-2 gap-3 sm:gap-4">
          {/* Good Meals */}
          <div className="space-y-2 sm:space-y-3">
            <div className="flex items-center gap-1.5 sm:gap-2">
              <CheckCircle className="h-4 w-4 sm:h-5 sm:w-5 text-category-safe" />
              <h4 className="font-semibold text-category-safe text-sm sm:text-base">Optimal Meals</h4>
            </div>
            <div className="space-y-1.5 sm:space-y-2">
              {goodMeals.map((meal, i) => (
                <div key={i} className="flex items-center gap-1.5 sm:gap-2 p-1.5 sm:p-2 bg-category-safe/5 rounded-lg border border-category-safe/20">
                  <span className="text-lg sm:text-xl">{meal.emoji}</span>
                  <span className="text-xs sm:text-sm">{meal.name}</span>
                </div>
              ))}
            </div>
          </div>
          
          {/* Bad Meals */}
          <div className="space-y-2 sm:space-y-3">
            <div className="flex items-center gap-1.5 sm:gap-2">
              <XCircle className="h-4 w-4 sm:h-5 sm:w-5 text-category-danger" />
              <h4 className="font-semibold text-category-danger text-sm sm:text-base">Avoid These Combos</h4>
            </div>
            <div className="space-y-1.5 sm:space-y-2">
              {avoidMeals.map((meal, i) => (
                <div key={i} className="flex items-center gap-1.5 sm:gap-2 p-1.5 sm:p-2 bg-category-danger/5 rounded-lg border border-category-danger/20">
                  <span className="text-lg sm:text-xl">{meal.emoji}</span>
                  <span className="text-xs sm:text-sm">{meal.name}</span>
                </div>
              ))}
            </div>
          </div>
        </div>
        
        {/* Benefits */}
        <div className="p-3 sm:p-4 bg-secondary rounded-lg sm:rounded-xl">
          <p className="font-semibold mb-1.5 sm:mb-2 text-xs sm:text-sm">Following this approach leads to:</p>
          <div className="grid grid-cols-2 gap-1.5 sm:gap-2 text-[10px] sm:text-xs">
            <div className="flex items-center gap-1 sm:gap-1.5">
              <ArrowRight className="h-2.5 w-2.5 sm:h-3 sm:w-3 text-primary flex-shrink-0" />
              <span>↓ Insulin secretion</span>
            </div>
            <div className="flex items-center gap-1 sm:gap-1.5">
              <ArrowRight className="h-2.5 w-2.5 sm:h-3 sm:w-3 text-primary flex-shrink-0" />
              <span>↑ Fat oxidation</span>
            </div>
            <div className="flex items-center gap-1 sm:gap-1.5">
              <ArrowRight className="h-2.5 w-2.5 sm:h-3 sm:w-3 text-primary flex-shrink-0" />
              <span>↑ AMPK activation</span>
            </div>
            <div className="flex items-center gap-1 sm:gap-1.5">
              <ArrowRight className="h-2.5 w-2.5 sm:h-3 sm:w-3 text-primary flex-shrink-0" />
              <span>↑ Autophagy</span>
            </div>
            <div className="flex items-center gap-1 sm:gap-1.5">
              <ArrowRight className="h-2.5 w-2.5 sm:h-3 sm:w-3 text-primary flex-shrink-0" />
              <span>↓ Inflammation</span>
            </div>
            <div className="flex items-center gap-1 sm:gap-1.5">
              <ArrowRight className="h-2.5 w-2.5 sm:h-3 sm:w-3 text-primary flex-shrink-0" />
              <span>↓ mTOR</span>
            </div>
          </div>
        </div>
      </CardContent>
    </Card>
  );
}
