import { ShoppingCart } from 'lucide-react';
import { Button } from '@/components/ui/button';
import { useShoppingList } from '@/contexts/ShoppingListContext';
import { cn } from '@/lib/utils';

interface ShoppingListButtonProps {
  itemId: string;
  itemType: 'food' | 'cosmetic';
  className?: string;
  size?: 'sm' | 'default';
}

export const ShoppingListButton = ({ itemId, itemType, className, size = 'default' }: ShoppingListButtonProps) => {
  const { isInList, toggleItem } = useShoppingList();
  const inList = isInList(itemId, itemType);

  const handleClick = (e: React.MouseEvent) => {
    e.stopPropagation();
    toggleItem(itemId, itemType);
  };

  return (
    <Button
      variant="ghost"
      size={size === 'sm' ? 'icon' : 'default'}
      className={cn(
        'transition-colors',
        size === 'sm' ? 'h-8 w-8' : 'h-9 w-9',
        className
      )}
      onClick={handleClick}
      title={inList ? 'Remove from shopping list' : 'Add to shopping list'}
    >
      <ShoppingCart 
        className={cn(
          'transition-colors',
          size === 'sm' ? 'h-4 w-4' : 'h-5 w-5',
          inList ? 'fill-primary text-primary' : 'text-muted-foreground hover:text-primary'
        )}
      />
    </Button>
  );
};
