import { Alert, AlertDescription, AlertTitle } from '@/components/ui/alert';
import { AlertTriangle, ShieldAlert } from 'lucide-react';
import { useHealthProfile, TobinScore } from '@/hooks/useHealthProfile';
import { useAuth } from '@/hooks/useAuth';

interface TobinAlertProps {
  tobinScore?: TobinScore;
  className?: string;
}

const TobinAlert = ({ tobinScore, className = '' }: TobinAlertProps) => {
  const { user } = useAuth();
  const { checkTobinAlerts, profile } = useHealthProfile();

  if (!user || !tobinScore || !profile.show_alerts) {
    return null;
  }

  const alerts = checkTobinAlerts(tobinScore);

  if (alerts.length === 0) {
    return null;
  }

  const isCritical = alerts.length >= 3;

  return (
    <Alert variant="destructive" className={`${className} ${isCritical ? 'border-red-500 bg-red-50 dark:bg-red-950/20' : ''}`}>
      {isCritical ? (
        <ShieldAlert className="h-4 w-4" />
      ) : (
        <AlertTriangle className="h-4 w-4" />
      )}
      <AlertTitle className="flex items-center gap-2">
        {isCritical ? 'Critical Health Alert' : 'Health Alert'}
      </AlertTitle>
      <AlertDescription>
        <p className="text-sm mb-2">Based on your personal health profile:</p>
        <ul className="list-disc list-inside space-y-1">
          {alerts.map((alert, index) => (
            <li key={index} className="text-sm">{alert}</li>
          ))}
        </ul>
        {isCritical && (
          <p className="text-sm mt-2 font-medium">
            ⚠️ This item may significantly impact your health conditions. Consider alternatives.
          </p>
        )}
      </AlertDescription>
    </Alert>
  );
};

export default TobinAlert;
