// Single source of truth: re-export from AuthContext so all consumers
// (FavoritesContext, BarcodeScanner, etc.) share the same user state after sign-in.
import api from '@/lib/api';
import { useAuthContext } from '@/contexts/AuthContext';

export const useAuth = () => {
  const ctx = useAuthContext();
  const session = ctx.user && api.getAccessToken()
    ? { user: ctx.user, accessToken: api.getAccessToken()! }
    : null;
  return {
    ...ctx,
    session,
  };
};
