import { useEffect, useRef } from 'react';
import { useAuth } from './useAuth';
import api from '@/lib/api';

export const useMealReminders = () => {
  const { user } = useAuth();
  const hasChecked = useRef(false);

  useEffect(() => {
    // Only check once per session when user is logged in
    if (!user || hasChecked.current) return;

    const checkReminders = async () => {
      try {
        console.log('Checking meal prep reminders...');
        const data = await api.post('/meal-plans/check-reminders', { user_id: user.id });
        console.log('Reminder check result:', data);
      } catch (err) {
        console.error('Failed to check reminders:', err);
      }
    };

    hasChecked.current = true;
    checkReminders();
  }, [user]);
};
