import { useState, useCallback } from "react";
import { toast } from "sonner";
import { aiApi } from "@/lib/apiServices";

interface RecipeRequest {
  mealType?: string;
  servings?: number;
  preferences?: string;
}

export function usePhytoestrogenFreeRecipes() {
  const [content, setContent] = useState("");
  const [isGenerating, setIsGenerating] = useState(false);
  const [error, setError] = useState<string | null>(null);

  const generateRecipes = useCallback(async (request: RecipeRequest) => {
    setIsGenerating(true);
    setContent("");
    setError(null);

    try {
      const data = await aiApi.generatePhytoestrogenFreeRecipes(request);
      setContent(data.recipe || "");
      toast.success("Phytoestrogen-free recipes generated!");
    } catch (err) {
      const message = err instanceof Error ? err.message : "An error occurred";
      setError(message);
      toast.error(message);
    } finally {
      setIsGenerating(false);
    }
  }, []);

  const reset = useCallback(() => {
    setContent("");
    setError(null);
  }, []);

  return {
    content,
    isGenerating,
    error,
    generateRecipes,
    reset,
  };
}
