import { createRoot } from "react-dom/client";
import React from "react";

const rootEl = document.getElementById("root");
if (!rootEl) {
  document.body.innerHTML = "<h1>Root #root not found</h1>";
} else {
  rootEl.style.minHeight = "100vh";
  rootEl.style.background = "#e5e5e5";
  rootEl.style.padding = "5px";
  rootEl.style.fontFamily = "system-ui, sans-serif";
  rootEl.innerHTML = "<p style='margin:0'>Loading…</p>";

  function showError(msg: string, err?: unknown) {
    const extra = err instanceof Error ? (err.stack || err.message) : String(err);
    rootEl!.innerHTML = `<h1 style="color:#b91c1c">Load error</h1><pre style="white-space:pre-wrap;background:#fef2f2;padding:1rem;overflow:auto">${msg}</pre><pre style="font-size:12px;color:#666">${extra}</pre><button onclick="location.reload()" style="padding:8px 16px;cursor:pointer">Reload</button>`;
  }

  (async () => {
    try {
      await import("./index.css");
    } catch (e) {
      showError("CSS failed to load", e);
      return;
    }
    try {
      const App = (await import("./App.tsx")).default;
      const { ErrorBoundary } = await import("./ErrorBoundary");
      createRoot(rootEl).render(
        React.createElement(ErrorBoundary, null, React.createElement(App))
      );
    } catch (err) {
      showError(err instanceof Error ? err.message : String(err), err);
    }
  })();
}
