import { useEffect } from 'react';
import { Link } from 'react-router-dom';
import { Button } from '@/components/ui/button';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { XCircle, ArrowLeft } from 'lucide-react';
import { useSubscription } from '@/hooks/useSubscription';

const SubscriptionCanceled = () => {
  const { checkSubscription } = useSubscription();

  // Refresh subscription status when user lands here after canceling checkout
  useEffect(() => {
    checkSubscription();
  }, [checkSubscription]);

  return (
    <div className="min-h-screen bg-gradient-to-br from-emerald-50 via-white to-amber-50 flex items-center justify-center p-4">
      <Card className="max-w-md w-full text-center">
        <CardHeader>
          <div className="mx-auto mb-4 w-16 h-16 bg-amber-100 rounded-full flex items-center justify-center">
            <XCircle className="h-8 w-8 text-amber-600" />
          </div>
          <CardTitle className="text-2xl">Subscription Canceled</CardTitle>
        </CardHeader>
        <CardContent className="space-y-4">
          <p className="text-muted-foreground">
            Your subscription checkout was canceled. No charges were made.
          </p>
          
          <div className="pt-4 space-y-2">
            <Button asChild className="w-full">
              <Link to="/subscription">
                <ArrowLeft className="h-4 w-4 mr-2" />
                Back to Subscription
              </Link>
            </Button>
            <Button asChild variant="outline" className="w-full">
              <Link to="/">
                Go to Home
              </Link>
            </Button>
          </div>
        </CardContent>
      </Card>
    </div>
  );
};

export default SubscriptionCanceled;
