-- Create shopping list table
CREATE TABLE public.shopping_list (
  id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
  user_id UUID REFERENCES auth.users(id) ON DELETE CASCADE NOT NULL,
  item_id TEXT NOT NULL,
  item_type TEXT NOT NULL CHECK (item_type IN ('food', 'cosmetic')),
  quantity INTEGER DEFAULT 1,
  notes TEXT,
  is_purchased BOOLEAN DEFAULT false,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  UNIQUE(user_id, item_id, item_type)
);

-- Enable RLS
ALTER TABLE public.shopping_list ENABLE ROW LEVEL SECURITY;

-- Policies
CREATE POLICY "Users can view their own shopping list"
ON public.shopping_list FOR SELECT
USING (auth.uid() = user_id);

CREATE POLICY "Users can insert to their own shopping list"
ON public.shopping_list FOR INSERT
WITH CHECK (auth.uid() = user_id);

CREATE POLICY "Users can update their own shopping list"
ON public.shopping_list FOR UPDATE
USING (auth.uid() = user_id);

CREATE POLICY "Users can delete from their own shopping list"
ON public.shopping_list FOR DELETE
USING (auth.uid() = user_id);