-- Add columns for sharing and nutritional info to saved_recipes
ALTER TABLE public.saved_recipes 
ADD COLUMN share_token TEXT UNIQUE,
ADD COLUMN is_shared BOOLEAN DEFAULT false,
ADD COLUMN nutritional_info JSONB;

-- Create an index for faster share token lookups
CREATE INDEX idx_saved_recipes_share_token ON public.saved_recipes(share_token) WHERE share_token IS NOT NULL;

-- Add policy for public access to shared recipes
CREATE POLICY "Anyone can view shared recipes" 
ON public.saved_recipes 
FOR SELECT 
USING (is_shared = true AND share_token IS NOT NULL);