-- Create phytoestrogen exposure tracking table
CREATE TABLE public.phytoestrogen_exposure (
  id UUID NOT NULL DEFAULT gen_random_uuid() PRIMARY KEY,
  user_id UUID NOT NULL,
  phytoestrogen_id TEXT NOT NULL,
  phytoestrogen_name TEXT NOT NULL,
  potency TEXT NOT NULL CHECK (potency IN ('weak', 'moderate', 'strong')),
  food_source TEXT NOT NULL,
  servings DECIMAL(4,2) NOT NULL DEFAULT 1,
  logged_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  notes TEXT,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

-- Enable Row Level Security
ALTER TABLE public.phytoestrogen_exposure ENABLE ROW LEVEL SECURITY;

-- Create policies for user access
CREATE POLICY "Users can view their own exposure logs" 
ON public.phytoestrogen_exposure 
FOR SELECT 
USING (auth.uid() = user_id);

CREATE POLICY "Users can create their own exposure logs" 
ON public.phytoestrogen_exposure 
FOR INSERT 
WITH CHECK (auth.uid() = user_id);

CREATE POLICY "Users can update their own exposure logs" 
ON public.phytoestrogen_exposure 
FOR UPDATE 
USING (auth.uid() = user_id);

CREATE POLICY "Users can delete their own exposure logs" 
ON public.phytoestrogen_exposure 
FOR DELETE 
USING (auth.uid() = user_id);

-- Create index for faster queries
CREATE INDEX idx_phytoestrogen_exposure_user_date ON public.phytoestrogen_exposure (user_id, logged_at DESC);
CREATE INDEX idx_phytoestrogen_exposure_potency ON public.phytoestrogen_exposure (potency);