-- Create phytoestrogen goals table
CREATE TABLE public.phytoestrogen_goals (
  id UUID NOT NULL DEFAULT gen_random_uuid() PRIMARY KEY,
  user_id UUID NOT NULL UNIQUE,
  daily_limit INTEGER NOT NULL DEFAULT 10,
  weekly_limit INTEGER NOT NULL DEFAULT 50,
  alert_at_percentage INTEGER NOT NULL DEFAULT 80,
  show_alerts BOOLEAN NOT NULL DEFAULT true,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

-- Enable Row Level Security
ALTER TABLE public.phytoestrogen_goals ENABLE ROW LEVEL SECURITY;

-- Create policies for user access
CREATE POLICY "Users can view their own goals" 
ON public.phytoestrogen_goals 
FOR SELECT 
USING (auth.uid() = user_id);

CREATE POLICY "Users can create their own goals" 
ON public.phytoestrogen_goals 
FOR INSERT 
WITH CHECK (auth.uid() = user_id);

CREATE POLICY "Users can update their own goals" 
ON public.phytoestrogen_goals 
FOR UPDATE 
USING (auth.uid() = user_id);

CREATE POLICY "Users can delete their own goals" 
ON public.phytoestrogen_goals 
FOR DELETE 
USING (auth.uid() = user_id);

-- Create index
CREATE INDEX idx_phytoestrogen_goals_user ON public.phytoestrogen_goals (user_id);