-- Create a community-contributed products table for barcodes not in external databases
CREATE TABLE public.community_products (
  id UUID NOT NULL DEFAULT gen_random_uuid() PRIMARY KEY,
  barcode TEXT NOT NULL UNIQUE,
  product_name TEXT NOT NULL,
  brand TEXT,
  product_type TEXT NOT NULL DEFAULT 'cosmetic',
  categories TEXT,
  ingredients TEXT,
  image_url TEXT,
  contributed_by UUID REFERENCES auth.users(id),
  verified_count INT DEFAULT 0,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

-- Create index for fast barcode lookups
CREATE INDEX idx_community_products_barcode ON public.community_products(barcode);

-- Enable RLS
ALTER TABLE public.community_products ENABLE ROW LEVEL SECURITY;

-- Anyone can view community products
CREATE POLICY "Community products are viewable by everyone"
  ON public.community_products FOR SELECT
  USING (true);

-- Authenticated users can add products
CREATE POLICY "Authenticated users can add products"
  ON public.community_products FOR INSERT
  WITH CHECK (auth.uid() IS NOT NULL);

-- Contributors can update their own submissions
CREATE POLICY "Contributors can update their products"
  ON public.community_products FOR UPDATE
  USING (auth.uid() = contributed_by);

-- Add updated_at trigger
CREATE TRIGGER update_community_products_updated_at
  BEFORE UPDATE ON public.community_products
  FOR EACH ROW
  EXECUTE FUNCTION public.update_updated_at_column();